## -*-Tcl-*-
 # ###################################################################
 #  HTML and CSS mode - tools for editing HTML and CSS
 # 
 #  FILE: "htmlcssInit.tcl"
 #                                    created: 99-07-15 21.54.38 
 #                                last update: 01-11-17 11.48.54 
 #  Author: Johan Linde
 #  E-mail: <alpha_www_tools@go.to>
 #     www: <http://go.to/alpha_www_tools>
 #  
 # Version: 3.1.4 and 2.1.3
 # 
 # Copyright 1996-2001 by Johan Linde
 #  
 # This program is free software; you can redistribute it and/or modify
 # it under the terms of the GNU General Public License as published by
 # the Free Software Foundation; either version 2 of the License, or
 # (at your option) any later version.
 # 
 # This program is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 # GNU General Public License for more details.
 # 
 # You should have received a copy of the GNU General Public License
 # along with this program; if not, write to the Free Software
 # Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 # 
 # ###################################################################
 ##

#===============================================================================
# This file initialises a bunch of things, much of which are used in both CSS
# and HTML modes.
#===============================================================================

proc htmlcssInit.tcl {} {}

# HTML mode version
set htmlVersion 3.09
set html::PrefsFolder [file join $PREFS HTML]
set html::TmpFolder [file join $PREFS HTMLtmp]

#===============================================================================
#  Update preferences  #
#===============================================================================

if {![info exists html::PrefsVersion] || ${html::PrefsVersion} < $htmlVersion} {
	catch {htmlPrefsUpdater.tcl}
}

#===============================================================================
#  Menu icons  #
#===============================================================================

if {[alpha::package vsatisfies -loose ${alpha::version} 7.4.2]} {
	set htmlIconTxt {"Netscape Navigator 3" "Netscape Navigator 4" "Netscape Communicator" "Internet Explorer" Cyberdog iCab MacLynx Mosaic Mozilla Opera}
	set htmlIcons {135 293 294 295 281 297 296 942 306 305}
} else {
	set htmlIconTxt {"Netscape Navigator 3" "Netscape Navigator 4" "Netscape Communicator" "Internet Explorer" Cyberdog iCab MacLynx Mosaic}
	set htmlIcons {135 293 294 295 281 297 296 942}
}

# Menu icons
newPref v htmlMenuIcon 294 HTML
newPref v htmlUtilsMenuIcon 281 HTML

if {$HTMLmodeVars(htmlMenuIcon) == $HTMLmodeVars(htmlUtilsMenuIcon)} {
	foreach _tmp $htmlIcons {
		if {$HTMLmodeVars(htmlMenuIcon) != $_tmp} {
			set HTMLmodeVars(htmlUtilsMenuIcon) $_tmp
			prefs::modifiedModeVar htmlUtilsMenuIcon HTML
			break
		}
	}
}

set htmlMenu $HTMLmodeVars(htmlMenuIcon)
set htmlUtilsMenu $HTMLmodeVars(htmlUtilsMenuIcon)

#===============================================================================
#  Mode variables  #
#===============================================================================

# Set HTML element names in lower case
newPref f useLowerCase 0 CSS

# Line width
newPref v fillColumn 75 HTML
newPref v leftFillColumn 0 HTML
# word breaking and word wrapping
newPref v wordBreak {\w+} HTML
newPref v wordBreakPreface {(\W)} HTML
newPref v wrapBreak {[\w_]+} HTML
newPref v wrapBreakPreface {([^\w_])} HTML
newPref f wordWrap	1 HTML

# The content of these elements is indented
newPref v indentElements {DIR DL MENU OL TABLE TR UL} HTML

# browsers
if {![info exists browserSig] && [catch {getFileSig [icGetPref -t 1 Helperhttp]} browserSig]} {set browserSig MOSS}
# Browser signatures
newPref v browsers {MOSS MSIE} HTML

newPref v prefixString	"<!-- " HTML
newPref v suffixString	" -->" HTML

# Template folders.
newPref v templateFolders {} HTML
# Tag color
newPref v tagColor blue HTML
# Attribute color
newPref v attributeColor magenta HTML
# Simple coloring?
newPref f simpleColoring 0 HTML
# Always color immediately when typing
newPref f ColorImmediately 0 HTML
# Update META DATE?
newPref f updateMetaDate 0 HTML
# Should elements be lower case?
newPref f useLowerCase	0 HTML
# Should 's be inserted?
newPref	f useTabMarks	1 HTML
# Use the optional closing tag of these elements
newPref v optionalClosing {P TR TD TH} HTML
# Active window sets
newPref v activeTargetSets {} HTML
# Add new target windows to this set
newPref v addTargetsTo {} HTML
# A list of content types
newPref v contenttypes {text/css text/javascript multipart/form-data} HTML
# A list of link types
newPref v linktypes {stylesheet alternate start next prev contents index glossary copyright 
chapter section subsection appendix help bookmark} HTML
# When browser is launched, should it be brought to front?
newPref	f browseInForeground	1 HTML
# Save without asking when sending file to browser?
newPref f saveWithoutAsking 0 HTML
# List of commonly used character entities
newPref v commonChars {"less than" "greater than" "ampersand" "nonbreak space"} HTML
# Never ask about extensions?
newPref f hideExtensions 0 HTML
# Never ask about deprecated elements and attributes?
newPref f hideDeprecated 0 HTML
# Attributes globally not asked about at first
newPref v dontaskforAttributes {} HTML
# Attributes globally never asked about
newPref v neveraskforAttributes {} HTML
# Attributes globally always asked about
newPref v alwaysaskforAttributes {} HTML
# Beep when asking for attributes in the status bar?
newPref f promptNoisily 1 HTML
# Flash status bar for first attribute?
newPref f flashStatusBar 1 HTML
# Input from dialog windows or status bar?
newPref f useBigWindows 1 HTML
# Change attributes in dialog windows or status bar?
newPref f changeInBigWindows 1 HTML
# Create new file if missing without asking when cmd-double-clicking a link.
newPref f createWithoutAsking 0 HTML
# Cmd-double-click on non text file link opens file?
newPref f openNonTextFile 1 HTML
# Return on non text file in home page window opens file?
newPref f homeOpenNonTextFile 1 HTML
# Check anchors in links?
newPref f checkAnchors 1 HTML
# Case sensistive link checking?
newPref f caseSensitive 0 HTML
# Check links with Big Brother?
newPref f useBigBrother 0 HTML
newPref f checkInFront 1 HTML
newPref f useBBoptions 1 HTML
newPref f ignoreRemote 0 HTML
newPref f ignoreLocal 0 HTML
# Folder for HTML manual.
if {![alpha::package vsatisfies -loose ${alpha::tclversion} 7.4.3]} {
	newPref v manualFolder [file join $HOME "HTML mode manual"] HTML
}
newPref v manualStartPage 0 HTML
# FTP servers
newPref v FTPservers {} HTML
# Last modified string
newPref v lastModified "Last modified" HTML
# 'Insert include tags' only inserts tags, and not the file?
newPref f includeOnlyTags 1 HTML
# Preserve line-endings when updating includes?
newPref f preserveLineEndings 0 HTML
# Color JavaScript keywords?
newPref f JavaScriptColoring 0 HTML
# Color of JavaScript keywords
newPref v JavaScriptColor	magenta HTML
# Color of strings
newPref v stringColor green HTML
# Color of JavaScript comments
newPref v JavaCommentColor red HTML
# Color CSS keywords?
newPref f CSSColoring 0 HTML
# Color of CSS keywords
newPref v CSSColor cyan HTML
# Home pages.
newPref v homePages {} HTML
# Media types
newPref v mediatypes {aural braille embossed handheld print projection screen tty tv all} HTML
# Active color sets
newPref v activeColorSets {} HTML
# Active URL sets
newPref v activeURLSets {} HTML
# Add new URLs to this set
newPref v addURLsTo {} HTML
# Explain types prefs window.
newPref f explainTypePrefs 1 HTML
# Auto-indent when typing >
newPref f electricGreater 1 HTML
# Warn before mirroring with Anarchie
newPref f anarchieMirrorWarn 1 HTML
# Use old style "Comment Paragraph"
newPref f oldStyleCommPara 0 HTML
# Open attribute dialog after completing?
newPref f attrDialogAfterCompleting 1 HTML
# Adjust indentation when inserting a template in the beginning of a line?
newPref f adjustIndentation 1 HTML

#===============================================================================
#  Other variables  #
#===============================================================================

# These elements have optional closing tags
set html::OptionalClosingTags {COLGROUP DD DT LI OPTION P THEAD TBODY TFOOT TR TH TD}
# These elements can be in document HEAD.
set html::HeadElements {BASE ISINDEX LINK META STYLE SCRIPT OBJECT}
# These elements are plug-ins.
set html::Plugins {EMBED}
# These elements do not appear in the strict DTD
set html::NotInStrict {APPLET FONT CENTER DIR MENU STRIKE S U BASEFONT ISINDEX NOFRAMES IFRAME FRAMESET FRAME}
# These elements are deprecated
set html::DeprecatedElems {APPLET FONT CENTER DIR MENU STRIKE S U BASEFONT ISINDEX}
# These elements do not appear in transitional DTD
set html::NotInTransitional {FRAME FRAMESET}
# These elements are extensions to HTML
set html::HTMLextensions {BGSOUND BLINK EMBED ILAYER KEYGEN LAYER MARQUEE MULTICOL NOBR NOEMBED NOLAYER SERVER SPACER WBR}
# Formatting styles
lappend html::formattingStyles NO-FORMATTING C-STYLE-FORMATTING
set html::indentLineProcs(NO-FORMATTING) {}
set html::formatBlockProcs(NO-FORMATTING) {}
set html::correctIndentProc(NO-FORMATTING) {}
set html::indentLineProcs(C-STYLE-FORMATTING) {::indentLine}
set html::formatBlockProcs(C-STYLE-FORMATTING) {::indentRegion}
if {[alpha::package vsatisfies -loose ${alpha::tclversion} 7.5fc1]} {
	set html::correctIndentProc(C-STYLE-FORMATTING) {::correctBracesIndentation}
} elseif {[alpha::package vsatisfies -loose ${alpha::tclversion} 7.4.2]} {
	set html::correctIndentProc(C-STYLE-FORMATTING) {::correctIndentation}
} else {
	set html::correctIndentProc(C-STYLE-FORMATTING) {}
}

foreach __vvv [array names HTMLmodeVars] {
	set HTMLmodeVarsInvisible($__vvv) 1
}

unset __vvv

# For compatibility with Alpha 7.3.
if {![alpha::package vsatisfies -loose ${alpha::tclversion} 7.4a2]} {
	;proc tclAE::build::resultData {args} {
		return [aeparse::keywordValue ---- \
			[aeparse::event [eval AEBuild -r $args]] \
		]
	}
}

if {![alpha::package vsatisfies -loose ${alpha::tclversion} 7.4b8]} {
	;proc HTMLmodifyFlags {} {
		html::modifyFlags
	}
	;proc CSSmodifyFlags {} {
		css::modifyFlags
	}
}
if {![alpha::package vsatisfies -loose ${alpha::tclversion} 7.4b13]} {
	namespace eval dialog::specialView {}
	;proc dialog::specialView::file {vv} {
		if {[set sl [string length $vv]] > 33} {
		set vv "[string range $vv 0 8]...[string range $vv [expr {$sl -21}] end]"
		}
		return $vv
	}
	;proc win::StripCount {name} {
		regsub { <[0-9]+>} $name {} name
		return $name
	}
}

if {![alpha::package vsatisfies -loose ${alpha::tclversion} 7.5b1]} {
	;proc file::convertLineEndings {f eolType} {
		set contents [file::readAll $f]
		if {[regexp {\n\r} $contents]} {
			set thisType "win"
		} elseif {[regexp {\r} $contents]} {
			set thisType "unix"
		} else {
			set thisType "mac"
		}
		if {$thisType == $eolType} {return}
		switch $thisType {
			"mac" {
				if {$eolType == "win"} {
					regsub -all "\n" $contents "\r\n" contents
				}
			}
			"unix" {
				if {$eolType == "win"} {
					regsub -all "\r" $contents "\r\n" contents
				}
			}
			"win" {
				switch -- $eolType {
					"mac" {
						regsub -all "\n\r" $contents "\r" contents
					}
					"unix" {
						regsub -all "\n\r" $contents "\n" contents
					}
				}
			}
		}
		
		if {$eolType == "mac"} {
			file::writeAll $f $contents 1
		} else {
			set fid [tclAE::build::resultData 'MACS' rdwr open ---- [makeAlis $f] perm true()]
			AEBuild 'MACS' rdwr writ ---- $contents refn $fid
			if {$thisType == "win"} {
				AEBuild 'MACS' rdwr seof ---- $fid set2 [string length $contents]
			}
			AEBuild 'MACS' rdwr clos ---- $fid
		}
	}
}

# Comment characters
proc html::SetCommentCharacters {} {
	global HTMLmodeVars HTML::commentCharacters
	# changed for new 'isIn' functionality.
	set HTML::commentCharacters(General) ""
	if {$HTMLmodeVars(oldStyleCommPara)} {
		set HTML::commentCharacters(Paragraph) [list "<!--" "-->" "|" ]
	} else {
		set HTML::commentCharacters(Paragraph) [list "<!--" "-->" " | " ]
	}
	set HTML::commentCharacters(Box) [list "<!--" 4 "-->" 3 "|" 3]
}

html::SetCommentCharacters

#
# Internal Globals
#
# Watch out! Large comments crashes Alpha!!!
set css::CommentRegexp {/\*[^*]*\*+([^/][^*]*\*+)*/}
set html::CommentRegexp {<!--([^-]|-[^-])*-->}
set htmlCurSel	""
set htmlIsSel	0
set htmlNumBbthChecking 0
set html::HideDeprecated 0
set html::HideExtensions 0
set html::HideFrames 0

proc css::DisableEnable {onoff} {
	global cssMenu
	enableMenuItem $cssMenu "@Charset" $onoff
	enableMenuItem $cssMenu "@Import" $onoff
	enableMenuItem $cssMenu "Preferences" $onoff
	enableMenuItem $cssMenu "Electrics" $onoff
}

if {[alpha::package vsatisfies -loose ${alpha::tclversion} 7.5fc1]} {
	proc CSS::correctIndentation {args} {
		eval ::correctBracesIndentation $args
	}
}

#===============================================================================
#  Colors for background, text, links etc.  #
#===============================================================================

# Predefined colors
set css::Colors {ActiveBorder ActiveCaption AppWorkspace Background ButtonFace ButtonHighlight
ButtonShadow ButtonText CaptionText GrayText Highlight HighlightText InactiveBorder
InactiveCaption InactiveCaptionText InfoBackground InfoText Menu MenuText Scrollbar
ThreeDDarkShadow ThreeDFace ThreeDHighLight ThreeDLightShadow ThreeDShadow Window
WindowFrame WindowText}

proc html::NewColor {var val } {
	global html::ColorName
	global html::ColorNumber
	set html::ColorName($var) $val 
	set html::ColorNumber($val) $var
}
html::NewColor black	"#000000"
html::NewColor silver	"#C0C0C0"
html::NewColor gray		"#808080"
html::NewColor white	"#FFFFFF"
html::NewColor maroon	"#800000"
html::NewColor red		"#FF0000"
html::NewColor purple	"#800080"
html::NewColor fuchsia	"#FF00FF"
html::NewColor green	"#008000"
html::NewColor lime		"#00FF00"
html::NewColor olive	"#808000"
html::NewColor yellow	"#FFFF00"
html::NewColor navy		"#000080"
html::NewColor blue		"#0000FF"
html::NewColor teal		"#008080"
html::NewColor aqua		"#00FFFF"

# A list of colours
set html::basicColors [lsort [array names html::ColorName]]
rename html::NewColor ""
html::ReadActiveColorSets
html::ReadActiveCacheSets URLs
html::ReadActiveCacheSets Targets

#===============================================================================
#  Cmd-Double-click  #
#===============================================================================

proc HTML::DblClick {from to} {
	global mode file::separator
	global HTMLmodeVars filepats
	
	# Build regular expressions with URL attrs.
	if {$mode == "HTML"} {
		set exp [html::URLregexp]
	}

	set expcss {(url)\([ \t\r\n]*("[^"]+"|'[^']+'|[^ "'\t\n\r\)]+)[ \t\r\n]*\)}
	# Check if user clicked on a link.
	if {($mode == "HTML" && ![catch {search -s -f 0 -r 1 -i 1 -m 0 $exp $from} res] && [pos::compare [lindex $res 1] > $from]) ||
	(![set curl [catch {search -s -f 0 -r 1 -i 1 -m 0 $expcss $from} res]] && [pos::compare [lindex $res 1] > $from])} {
		# Get path to this window.
		if {![string length [set thisURL [html::ThisFilePath 1]]]} {return}
		# Get path to link.
		if {[info exists curl]} {set exp $expcss}
		regexp -nocase $exp [eval getText $res] dum1 dum2 linkTo
		set linkTo [html::URLunEscape [string trim $linkTo "\"' \t\r\n"]]
		# Anchors points to file itself if no BASE. (No BASE if [llength $thisURL] > 4)
		if {[string index $linkTo 0] == "#" && [llength $thisURL] > 4} {
			set a [string range $linkTo 1 end]
			if {![catch {search -s -f 1 -r 1 -i 1 -m 0 \
				"<(A|MAP)\[ \t\r\n\]+\[^>\]*NAME\[ \t\r\n\]*=\[ \t\r\n\]*(\"\[ \t\r\n\]*$a\[ \t\r\n\]*\"|'\[ \t\r\n\]*$a\[ \t\r\n\]*'|$a)(>|\[ \t\r\n\]+\[^<>\]*>)" [minPos]} anc]} {
				goto [lindex $anc 0]
				insertToTop
			}
			return
		}
		if {[catch {lindex [html::PathToFile [lindex $thisURL 0] [lindex $thisURL 1] [lindex $thisURL 2] [lindex $thisURL 3] $linkTo] 0} linkToPath]} {
			if {$linkToPath == ""} {
				message "Link not well-defined."
			} else {
				message "Link points to $linkToPath. Doesn't map to a file on the disk."
			}
			return
		}
		# Does the file exist? 
		if {[file exists $linkToPath] && ![file isdirectory $linkToPath]} {
			# Is it a text file?
			if {[getFileType $linkToPath] == "TEXT"} {
				edit -c $linkToPath
				if {[regexp {[^#]*#(.+)$} $linkTo dum anchor] && ![catch {search -s -f 1 -r 1 -i 1 -m 0 \
				  "<(A|MAP)\[ \t\r\n\]+\[^>\]*NAME\[ \t\r\n\]*=\[ \t\r\n\]*(\"\[ \t\r\n\]*$anchor\[ \t\r\n\]*\"|'\[ \t\r\n\]*$anchor\[ \t\r\n\]*'|$anchor)(>|\[ \t\r\n\]+\[^<>\]*>)" [minPos]} anc]} {
					goto [lindex $anc 0]
					insertToTop
				}
			} elseif {[set HTMLmodeVars(openNonTextFile)] && [getFileType $linkToPath] != "APPL"} {
				launchDoc $linkToPath
			} else {
				message "[file tail $linkToPath] is not a text file."
			}
		} else {
			set isAnHtmlFile 0
			set sufficies ""
			foreach mm {HTML CSS JScr} {
				if {[info exists filepats($mm)]} {set sufficies [concat $sufficies $filepats($mm)]}
			}
			foreach suffix $sufficies {
				if {[string match $suffix $linkToPath]} {set isAnHtmlFile 1}
			}
			if {(![file exists $linkToPath] && !$isAnHtmlFile) || [file isdirectory $linkToPath] ||
			![regexp "\[^${file::separator}\]+" $linkToPath disk] || ![file exists $disk${file::separator}]} {
				message "Cannot open [file tail $linkToPath]."
			} else {
				set htmlFile [file tail $linkToPath]
				if {![set HTMLmodeVars(createWithoutAsking)]} {
					set dval [dialog -w 350 -h 160 -t "The file '$htmlFile' does not exist.\
					  Do you want to open a new empty window with this name?\
					  It will automatically be saved in the right place,\
					  and if necessary, new folders will be created."  10 10 340 100 \
					  -c "Create missing file without asking in the future." [set HTMLmodeVars(createWithoutAsking)] 10 105 340 120 \
					  -b Yes 270 130 335 150 -b No 185 130 250 150]
					if {[lindex $dval 2]} {return}
					if {[lindex $dval 0] != [set HTMLmodeVars(createWithoutAsking)]} {
						set HTMLmodeVars(createWithoutAsking) [lindex $dval 0]
						prefs::modifiedModeVar createWithoutAsking HTML
					}
				}
				# Create a new file and open it.
				foreach p [split [file dirname $linkToPath] ${file::separator}] {
					append path "$p${file::separator}"
					# make new folders if needed.
					if {![file exists $path]} {
						file mkdir $path
					} elseif {![file isdirectory $path]} {
						alertnote "Cannot make a new folder '[file tail [file dirname $path]]'.\
						There is already a file with the same name."
						return
					}
				}
				append path "$htmlFile"
				# create an empty file.
				set fid [open $path w]
				# I suppose it's best to close it, too.
				close $fid
				edit $path
			}
		}
	} elseif {$mode == "HTML"} { 
		if {![catch {search -s -f 0 -r 1 -i 1 -m 0 {[ \t\r\n](FILE|PATH|INCLPATH)=\"[^\"]+\"} $from} res] && [pos::compare [lindex $res 1] > $from]} {
			regexp -nocase {(FILE|PATH|INCLPATH)=\"[^\"]+\"} [eval getText $res] fil
			set fil [html::ResolveInclPath $fil [html::WhichInclFolder [set win [html::StrippedFrontWindowPath]]] [file dirname $win]]
			if {[file exists $fil]} {
				edit -c $fil
			} else {
				beep
				message "File not found."
			}
		} elseif {[html::IsInContainer SCRIPT]} {
			JScr::DblClick $from $to
		} elseif {[html::IsInContainer STYLE]} {
			global css::IsDescriptor
			if {![catch {search -s -f 0 -r 1 -m 0 {[ \t\r\n]+[^ \t\r\n;:]+[ \t\r\n]*:} $from} res] && [pos::compare [lindex $res 1] >= $to]} {
				set css::IsDescriptor [css::IsInAtRule font-face]
				css::Dialog [string tolower [string trim [eval getText $res] " \t\r\n:"]]
			}
		} elseif {![html::RevealColor 1]} {
			html::EditTag 2
		}
	}
}
